******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


*********
* Setup *
*********

*Loop through ACS surveys from 2005 through 2015
forval year = 2005(1)2015 {

*Bite sized pieces (year of entry) in order to not crash Stata
local end = `year'-1
forval y = 1900(1)`end' {
	*This file contains the original "Personal" ACS data for year `y',
		*which has been converted to .dta format using StatTransfer:
	use "$internal_dir/data/ACS `year'/acs`year'.dta" if yoe==`y', clear
	display "STARTING YEAR `y'"
	
	*Consistent schooling variable changes names in 2008
	if `year'>=2008 {
		drop schl
		rename schlr schl
		}
	
	qui keep pwgt yoe pob REPW* schl age 
	qui destring pob, replace
	qui keep if pob>=60 & pob<=528
	qui save "$internal_dir/data/ACS `year'/acs`year'_`y'", replace
	}
clear 


************************
* Append and Harmonize *
************************

*Append together
forval y = 1900(1)`end' {
	append using "$internal_dir/data/ACS `year'/acs`year'_`y'.dta"
	erase "$internal_dir/data/ACS `year'/acs`year'_`y'.dta"
	}

gen sample = 1 /* This will be used to create counts for each regression cell */

*Netherlands Antilles
replace pob = 336 if pob>=344 & pob<=348

*South Sudan --> Sudan
replace pob = 451 if pob==463

*Korea --> South Korea
replace pob = 220 if pob==217

*St. Barts --> Guadeloupe
replace pob = 331 if pob==337


**********************	
* Relevant Estimates *
**********************

*To produce yearly inflow estimates: collapse (sum) pwt, by(yoe pob)
*To produce counts for supporting documentation: collapse (sum) sample, by(yoe pob)
preserve
	collapse (sum) sample pwgt, by(yoe pob)
	rename pwgt flows`year'
	rename sample sample`year'
	rename yoe year
	rename pob country
	drop if year==`year' | year==.
	save "$internal_dir/data/ACS `year'/acs`year'est_flows.dta", replace
restore

*To produce yearly inflow estimates: collapse (sum) pwt, by(yoe pob age_at_mig)
*To produce counts for supporting documentation: collapse (sum) sample, by(yoe pob age_at_mig)
preserve
	gen age_at_mig = age-(`year'-yoe) /*Age at migration is current age minus years since entry*/
	collapse (sum) sample pwgt, by(yoe pob age_at_mig) fast
	rename yoe year
	rename pob country
	rename pwgt migs
	save "$internal_dir/data/ACS `year'/acs`year'est_flows_by_age.dta", replace
restore

}
